/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.structure;

import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Category;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Vulnerability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

public class Bom {
    private final UUID uuid = UUID.randomUUID();
    private String product;
    private String project;
    private String version;
    private long creationTimestamp;
    private long updateTimestamp;
    private String licensePolicy;
    private String sourcePath;
    private String localSourcePath;
    private FileNode rootNode;
    private long numberOfFiles;
    private List<Category> categories;
    private List<Vulnerability> vulnerabilities;

    public void setRootNode(FileNode rootNode) {
        this.rootNode = rootNode;
        this.rootNode.setName("");
        this.rootNode.setParent(null);
    }

    public Category getCategory(DefaultCategory type) {
        return this.categories.stream().filter(c -> c.getType().equals((Object)type)).findAny().orElseThrow(IllegalStateException::new);
    }

    public void addCategory(Category category) {
        this.getCategories().add(category);
    }

    public List<Component> getComponentsFromSource(BomSource source) {
        return this.categories.stream().map(Category::getComponents).flatMap(Collection::stream).filter(c -> c.getSource().equals((Object)source)).collect(Collectors.toList());
    }

    public void addVulnerability(Vulnerability vulnerability) {
        this.getVulnerabilities().add(vulnerability);
    }

    @Generated
    private static long $default$creationTimestamp() {
        return -1L;
    }

    @Generated
    private static long $default$updateTimestamp() {
        return -1L;
    }

    @Generated
    private static List<Category> $default$categories() {
        return new ArrayList<Category>();
    }

    @Generated
    private static List<Vulnerability> $default$vulnerabilities() {
        return new ArrayList<Vulnerability>();
    }

    @Generated
    Bom(String product, String project, String version, long creationTimestamp, long updateTimestamp, String licensePolicy, String sourcePath, String localSourcePath, FileNode rootNode, long numberOfFiles, List<Category> categories, List<Vulnerability> vulnerabilities) {
        this.product = product;
        this.project = project;
        this.version = version;
        this.creationTimestamp = creationTimestamp;
        this.updateTimestamp = updateTimestamp;
        this.licensePolicy = licensePolicy;
        this.sourcePath = sourcePath;
        this.localSourcePath = localSourcePath;
        this.rootNode = rootNode;
        this.numberOfFiles = numberOfFiles;
        this.categories = categories;
        this.vulnerabilities = vulnerabilities;
    }

    @Generated
    public static BomBuilder builder() {
        return new BomBuilder();
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getProduct() {
        return this.product;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Generated
    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    @Generated
    public String getLicensePolicy() {
        return this.licensePolicy;
    }

    @Generated
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Generated
    public String getLocalSourcePath() {
        return this.localSourcePath;
    }

    @Generated
    public FileNode getRootNode() {
        return this.rootNode;
    }

    @Generated
    public long getNumberOfFiles() {
        return this.numberOfFiles;
    }

    @Generated
    public List<Category> getCategories() {
        return this.categories;
    }

    @Generated
    public List<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    @Generated
    public void setProduct(String product) {
        this.product = product;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @Generated
    public void setUpdateTimestamp(long updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    @Generated
    public void setLicensePolicy(String licensePolicy) {
        this.licensePolicy = licensePolicy;
    }

    @Generated
    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Generated
    public void setLocalSourcePath(String localSourcePath) {
        this.localSourcePath = localSourcePath;
    }

    @Generated
    public void setNumberOfFiles(long numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
    }

    @Generated
    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    @Generated
    public void setVulnerabilities(List<Vulnerability> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bom)) {
            return false;
        }
        Bom other = (Bom)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCreationTimestamp() != other.getCreationTimestamp()) {
            return false;
        }
        if (this.getUpdateTimestamp() != other.getUpdateTimestamp()) {
            return false;
        }
        if (this.getNumberOfFiles() != other.getNumberOfFiles()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$licensePolicy = this.getLicensePolicy();
        String other$licensePolicy = other.getLicensePolicy();
        if (this$licensePolicy == null ? other$licensePolicy != null : !this$licensePolicy.equals(other$licensePolicy)) {
            return false;
        }
        String this$sourcePath = this.getSourcePath();
        String other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
            return false;
        }
        String this$localSourcePath = this.getLocalSourcePath();
        String other$localSourcePath = other.getLocalSourcePath();
        if (this$localSourcePath == null ? other$localSourcePath != null : !this$localSourcePath.equals(other$localSourcePath)) {
            return false;
        }
        FileNode this$rootNode = this.getRootNode();
        FileNode other$rootNode = other.getRootNode();
        if (this$rootNode == null ? other$rootNode != null : !this$rootNode.equals(other$rootNode)) {
            return false;
        }
        List this$categories = this.getCategories();
        List other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        List this$vulnerabilities = this.getVulnerabilities();
        List other$vulnerabilities = other.getVulnerabilities();
        return !(this$vulnerabilities == null ? other$vulnerabilities != null : !((Object)this$vulnerabilities).equals(other$vulnerabilities));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + (int)($creationTimestamp >>> 32 ^ $creationTimestamp);
        long $updateTimestamp = this.getUpdateTimestamp();
        result = result * 59 + (int)($updateTimestamp >>> 32 ^ $updateTimestamp);
        long $numberOfFiles = this.getNumberOfFiles();
        result = result * 59 + (int)($numberOfFiles >>> 32 ^ $numberOfFiles);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $licensePolicy = this.getLicensePolicy();
        result = result * 59 + ($licensePolicy == null ? 43 : $licensePolicy.hashCode());
        String $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
        String $localSourcePath = this.getLocalSourcePath();
        result = result * 59 + ($localSourcePath == null ? 43 : $localSourcePath.hashCode());
        FileNode $rootNode = this.getRootNode();
        result = result * 59 + ($rootNode == null ? 43 : $rootNode.hashCode());
        List $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        List $vulnerabilities = this.getVulnerabilities();
        result = result * 59 + ($vulnerabilities == null ? 43 : ((Object)$vulnerabilities).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Bom(uuid=" + String.valueOf(this.getUuid()) + ", product=" + this.getProduct() + ", project=" + this.getProject() + ", version=" + this.getVersion() + ", creationTimestamp=" + this.getCreationTimestamp() + ", updateTimestamp=" + this.getUpdateTimestamp() + ", licensePolicy=" + this.getLicensePolicy() + ", sourcePath=" + this.getSourcePath() + ", localSourcePath=" + this.getLocalSourcePath() + ", rootNode=" + String.valueOf(this.getRootNode()) + ", numberOfFiles=" + this.getNumberOfFiles() + ", categories=" + String.valueOf(this.getCategories()) + ", vulnerabilities=" + String.valueOf(this.getVulnerabilities()) + ")";
    }
}

