/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner.packageScanner;

import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageScanOptions;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.ScanOptions;
import com.castsoftware.sca.scar.server.analyzer.scanner.packageScanner.PackageScanner;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.CargoLockProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.ComposerLockProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.GemfileLockProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.GemfileProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.GradleBuildProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.GradleLockProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.MavenProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.NuGetProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.PackageJsonProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.PackageLockProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.PipfileLockProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.PoetryAndUvProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.RequirementsTxtProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.YarnLockProcessor;
import com.castsoftware.sca.scar.server.bom.handler.ScannerPreferenceFetcher;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class PackageScanner
extends Scanner {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(PackageScanner.class);
    private final Bom currentBom;
    private final ScannerPreferenceFetcher scannerPreferenceFetcher;

    public PackageScanner(Bom currentBom, BomWizardConfiguration configuration, ScannerPreferenceFetcher scannerPreferenceFetcher) {
        super((ScanOptions)configuration.getPackageOptions(), configuration);
        this.currentBom = currentBom;
        this.scannerPreferenceFetcher = scannerPreferenceFetcher;
    }

    public void scan() {
        this.configuration.notify((Event)BomCreatorEvents.scan((Scanner)this));
        this.info("Start scan packages", new Object[0]);
        if (this.getScanOptions() != null) {
            ((PackageScanOptions)this.getScanOptions()).getPackageOptions().forEach(arg_0 -> this.processPackageManager(arg_0));
        } else {
            this.info("No defined package scanner options", new Object[0]);
        }
        this.info("End scan packages", new Object[0]);
        this.configuration.notify((Event)Event.finish(this.getClass()));
    }

    private Optional<FileNode> findSpecifiedPackageFile(String specified, String defaultName) {
        Optional<FileNode> current = Optional.of(this.currentBom.getRootNode());
        for (String p : specified.split("/")) {
            if (!StringUtils.isNotEmpty((CharSequence)p.trim()) || !current.isPresent()) continue;
            current = current.get().getChildren().stream().filter(f -> p.equals(f.getName())).findFirst();
        }
        if (current.isPresent() && !current.get().isFile()) {
            current = current.get().getChildren().stream().filter(f -> defaultName.equals(f.getName())).findFirst();
        }
        return current;
    }

    private void info(String format, Object ... objects) {
        this.log(LOGGER, PackageScanner.class, this.currentBom, format, objects);
    }

    protected Optional<FileNode> getPackageFile(PackageOption packageOption, String defaultFileName) {
        String filePath = packageOption.getFile() == null ? "" : packageOption.getFile();
        return filePath.endsWith("/") || filePath.endsWith("\\") ? this.currentBom.getRootNode().getChildren().stream().filter(FileNode::isFile).filter(f -> defaultFileName.equalsIgnoreCase(f.getName())).findFirst() : this.findSpecifiedPackageFile(filePath, defaultFileName);
    }

    protected Optional<FileNode> getPackageFileNuGet(PackageOption packageOption) {
        Optional target;
        String requestedPath = Objects.toString(packageOption.getFile(), "");
        FileNode baseNode = this.currentBom.getRootNode();
        if (StringUtils.isNotBlank((CharSequence)requestedPath) && (target = this.findNodeByPath(requestedPath)).isPresent()) {
            FileNode node = (FileNode)target.get();
            if (node.isFile()) {
                if (this.isNugetManifest(node)) {
                    return Optional.of(node);
                }
                baseNode = node.getParent() != null ? node.getParent() : this.currentBom.getRootNode();
            } else {
                baseNode = node;
            }
        }
        FileNode searchBase = baseNode;
        Comparator<FileNode> cmp = Comparator.comparingInt(fn -> {
            String name = fn.getName();
            if ("packages.config".equals(name)) {
                return 0;
            }
            if ("project.json".equals(name)) {
                return 1;
            }
            return 2;
        }).thenComparingInt(fn -> {
            int hops = (int)Stream.iterate(fn.getParent(), Objects::nonNull, FileNode::getParent).takeWhile(cur -> cur != searchBase).count();
            boolean reachesBase = Stream.iterate(fn, Objects::nonNull, FileNode::getParent).anyMatch(cur -> cur == searchBase);
            return reachesBase ? hops : 0x3FFFFFFF;
        }).thenComparing(FileNode::getName);
        return baseNode.stream().filter(FileNode::isFile).filter(arg_0 -> this.isNugetManifest(arg_0)).min(cmp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNugetManifest(FileNode node) {
        Set<String> NUGET_PROJ_EXT = Set.of(".csproj", ".fsproj", ".vbproj");
        String name = node.getName();
        if ("packages.config".equals(name)) return true;
        if ("project.json".equals(name)) return true;
        if (!NUGET_PROJ_EXT.stream().anyMatch(name::endsWith)) return false;
        return true;
    }

    private Optional<FileNode> findNodeByPath(String path) {
        String[] parts = path.split("[/\\\\]+");
        Optional<FileNode> cursor = Optional.of(this.currentBom.getRootNode());
        for (String part : parts) {
            if (StringUtils.isBlank((CharSequence)part)) continue;
            if (cursor.isEmpty()) break;
            FileNode current = cursor.get();
            cursor = current.getChildren().stream().filter(fn -> fn.getName().equals(part)).findFirst();
        }
        return cursor;
    }

    protected void processPackageManager(PackageOption option) {
        NuGetProcessor packageProcessor = null;
        Optional<FileNode> optionalPackageFileNode = Optional.empty();
        switch (1.$SwitchMap$com$castsoftware$sca$scar$server$analyzer$scanner$options$PackageOption$PackageType[option.getType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                optionalPackageFileNode = this.getPackageFile(option, "pom.xml");
                packageProcessor = new MavenProcessor(this.currentBom.getLocalSourcePath(), option, this.scannerPreferenceFetcher.getLocalRepository());
                break;
            }
            case 3: {
                optionalPackageFileNode = this.getPackageFile(option, "package-lock.json").or(() -> this.getPackageFile(option, "package.json"));
                packageProcessor = optionalPackageFileNode.filter(f -> "package.json".equals(f.getName())).map(f -> new PackageJsonProcessor(this.currentBom.getLocalSourcePath(), option)).orElseGet(() -> new PackageLockProcessor(this.currentBom.getLocalSourcePath(), option));
                break;
            }
            case 4: {
                optionalPackageFileNode = this.getPackageFile(option, "yarn.lock").or(() -> this.getPackageFile(option, "package.json"));
                packageProcessor = optionalPackageFileNode.filter(f -> "package.json".equals(f.getName())).map(f -> new PackageJsonProcessor(this.currentBom.getLocalSourcePath(), option)).orElseGet(() -> new YarnLockProcessor(this.currentBom.getLocalSourcePath(), option));
                break;
            }
            case 5: {
                optionalPackageFileNode = this.getPackageFile(option, "requirements.txt");
                packageProcessor = new RequirementsTxtProcessor(this.currentBom.getLocalSourcePath(), option);
                break;
            }
            case 6: {
                optionalPackageFileNode = this.getPackageFile(option, "poetry.lock");
                packageProcessor = new PoetryAndUvProcessor(this.currentBom.getLocalSourcePath(), option);
                break;
            }
            case 7: {
                optionalPackageFileNode = this.getPackageFile(option, "uv.lock");
                packageProcessor = new PoetryAndUvProcessor(this.currentBom.getLocalSourcePath(), option);
                break;
            }
            case 8: {
                optionalPackageFileNode = this.getPackageFile(option, "Pipfile.lock");
                packageProcessor = new PipfileLockProcessor(this.currentBom.getLocalSourcePath(), option);
                break;
            }
            case 9: {
                optionalPackageFileNode = this.getPackageFile(option, "composer.lock");
                packageProcessor = new ComposerLockProcessor(this.currentBom.getLocalSourcePath(), option);
                break;
            }
            case 10: {
                optionalPackageFileNode = this.getPackageFile(option, "gradle.lockfile");
                packageProcessor = new GradleLockProcessor(this.currentBom.getLocalSourcePath(), option);
                break;
            }
            case 11: {
                optionalPackageFileNode = this.getPackageFile(option, "build.gradle");
                packageProcessor = new GradleBuildProcessor(this.currentBom.getLocalSourcePath(), option);
                break;
            }
            case 12: {
                optionalPackageFileNode = this.getPackageFileNuGet(option);
                packageProcessor = new NuGetProcessor(this.currentBom.getLocalSourcePath(), option);
                break;
            }
            case 13: {
                optionalPackageFileNode = this.getPackageFile(option, "Cargo.lock");
                packageProcessor = new CargoLockProcessor(this.currentBom.getLocalSourcePath(), option);
                break;
            }
            case 14: {
                optionalPackageFileNode = this.getPackageFile(option, "Gemfile.lock").or(() -> this.getPackageFile(option, "Gemfile"));
                packageProcessor = optionalPackageFileNode.filter(f -> "Gemfile".equals(f.getName())).map(f -> new GemfileProcessor(this.currentBom.getLocalSourcePath(), option)).orElseGet(() -> new GemfileLockProcessor(this.currentBom.getLocalSourcePath(), option));
                break;
            }
        }
        if (packageProcessor != null) {
            AtomicInteger counter = new AtomicInteger(0);
            Component notScannedComponent = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL);
            if (optionalPackageFileNode.isEmpty()) {
                this.info("No package file found for %s", new Object[]{option.toString()});
                return;
            }
            packageProcessor.getSnippets((FileNode)optionalPackageFileNode.get()).stream().peek(n -> counter.incrementAndGet()).forEach(arg_0 -> ((Component)notScannedComponent).addSnippet(arg_0));
            this.info("added %d snippets to %s", new Object[]{counter.get(), notScannedComponent.getName()});
        }
    }
}

