/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner.options;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.FileFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FileFilter {
    private final Map<LineFilter, List<Object>> lineFilters = new HashMap();
    private FilterType type;

    public static String deregexize(String l) {
        if (!l.startsWith("^")) {
            return l;
        }
        return Arrays.stream(l.substring(1, l.length() - 1).split("\\|")).map(e -> e.replaceAll("\\\\\\\\", "\\\\").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\[\\^", "[!").replaceAll("\\.\\*", "*").replaceAll("(?<!\\\\)\\.", "?").replaceAll("\\\\\\.", ".")).collect(Collectors.joining(";"));
    }

    public FileFilter() {
        this.setExclude();
    }

    public FilterType getType() {
        return this.type;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public FileFilter setInclude() {
        this.type = FilterType.INCLUDE;
        return this;
    }

    public FileFilter setExclude() {
        this.type = FilterType.EXCLUDE;
        return this;
    }

    @JsonIgnore
    public boolean isInclude() {
        return this.type.equals((Object)FilterType.INCLUDE);
    }

    @JsonIgnore
    public boolean isExclude() {
        return this.type.equals((Object)FilterType.EXCLUDE);
    }

    public FileFilter addLineFilter(LineFilter filter, String value) {
        if (!this.lineFilters.containsKey(filter)) {
            this.lineFilters.put(filter, new ArrayList());
        }
        switch (filter.getType().ordinal()) {
            case 0: {
                ((List)this.lineFilters.get(filter)).add(Pattern.compile("^" + Arrays.stream(value.replaceAll("[()]", "").replaceAll("\\\\", "\\\\\\\\").replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*").replaceAll("\\?", ".").replaceAll("\\[!", "[^").split(";")).map(t -> "(" + t + ")").collect(Collectors.joining("|")) + "$"));
                break;
            }
            case 1: {
                ((List)this.lineFilters.get(filter)).add(Long.valueOf(value));
                break;
            }
        }
        return this;
    }

    public Map<LineFilter, List<Object>> getLineFilters() {
        return this.lineFilters;
    }
}

