/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.tools;

import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxLicense;
import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxLicenseChoice;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CdxLicenseDeserializer
extends JsonDeserializer<CdxLicenseChoice> {
    public CdxLicenseChoice deserialize(@NonNull JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode rootNode = (JsonNode)p.getCodec().readTree(p);
        if (rootNode.isEmpty()) {
            return null;
        }
        ArrayNode nodes = rootNode.isArray() ? (ArrayNode)rootNode : new ArrayNode(null).add(rootNode);
        CdxLicenseChoice licenseChoice = new CdxLicenseChoice();
        for (JsonNode node : nodes) {
            if (node.has("license")) {
                this.processLicenseNode(p, node.get("license"), licenseChoice);
                continue;
            }
            if (!node.has("expression")) continue;
            licenseChoice.setExpression(node.get("expression").asText());
            return licenseChoice;
        }
        return licenseChoice;
    }

    private void processLicenseNode(JsonParser p, @NonNull JsonNode licenseNode, CdxLicenseChoice licenseChoice) throws IOException {
        ArrayNode licenseNodes = licenseNode.isArray() ? (ArrayNode)licenseNode : new ArrayNode(null).add(licenseNode);
        for (JsonNode license : licenseNodes) {
            CdxLicense licenseObj = (CdxLicense)p.getCodec().treeToValue((TreeNode)license, CdxLicense.class);
            licenseChoice.addLicense(licenseObj);
        }
    }
}

