/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner;

import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.ScanOptions;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class Scanner {
    protected final ScanOptions scanOptions;
    protected final BomWizardConfiguration configuration;

    public Scanner(ScanOptions scanOptions, BomWizardConfiguration configuration) {
        this.scanOptions = scanOptions;
        this.configuration = (BomWizardConfiguration)Guards.notNull((Object)configuration);
    }

    public abstract void scan();

    protected String findMinimalPath(Set<String> paths) {
        String min = StringUtils.getCommonPrefix((String[])paths.toArray(new String[0]));
        return min.substring(0, min.lastIndexOf("/") + 1);
    }

    protected void log(Logger logger, Class<? extends Scanner> clazz, Bom bom, String format, Object ... objects) {
        String stdFormat = "[%s][BOM %s] ";
        Optional obom = Opt.ofNullable((Object)bom);
        String unknown = "unknown";
        logger.info(String.format(Opt.ofNullable((Object)format).map(stdFormat::concat).orElse(stdFormat), Stream.concat(Stream.of(clazz.getSimpleName(), String.join((CharSequence)":", obom.map(Bom::getProduct).orElse(unknown), obom.map(Bom::getProject).orElse(unknown), obom.map(Bom::getVersion).orElse(unknown))), Opt.ofNullable((Object)objects).stream().flatMap(Stream::of)).toArray(Object[]::new)));
    }

    @Generated
    public ScanOptions getScanOptions() {
        return this.scanOptions;
    }
}

