/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner;

import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.ScaScanOptions;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.ScanOptions;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.analyzer.structure.FileElement;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.License;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.structure.Vulnerability;
import com.castsoftware.sca.scar.server.analyzer.tools.FileParsingTool;
import com.castsoftware.sca.scar.server.analyzer.tools.ScaFilters;
import com.castsoftware.sca.scar.server.bom.handler.AnalyzerBomFetcher;
import com.castsoftware.sca.scar.server.risk.ObsolescenceComputer;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaFingerprint;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaHref;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaProject;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaProjectVersion;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaProjectVersionList;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaVulnerability;
import com.castsoftware.sca.scar.server.sam.requester.DataApiRequester;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.util.java.Asyncs;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;

public class ScaScanner
extends Scanner {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(ScaScanner.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private static final int CHUNK_SIZE = 20;
    private static final double MONITOR_FILE_RATIO = 0.6;
    private static final double MONITOR_COMP_RATIO = 0.4;
    private final Executor executor;
    private final Bom currentBom;
    private final DataApiRequester dataAPI;
    private final ScaScanOptions.ScaLevelType scanLevel = this.getScanOptions() != null ? ((ScaScanOptions)this.getScanOptions()).getScaLevel() : ScaScanOptions.ScaLevelType.FULL_DETECT;
    private final AnalyzerBomFetcher dbFetcher;
    private double monitor_totalFiles = -1.0;
    private double monitor_totalComps = -1.0;

    public ScaScanner(Executor executor, DataApiRequester requester, Bom currentBom, BomWizardConfiguration configuration, AnalyzerBomFetcher fetcher) {
        super((ScanOptions)configuration.getScaOptions(), configuration);
        this.executor = executor;
        this.currentBom = currentBom;
        this.dataAPI = requester;
        this.dbFetcher = fetcher;
    }

    public void scan() {
        this.configuration.notify((Event)BomCreatorEvents.scan((Scanner)this));
        this.info("Start SCA scanner", new Object[0]);
        this.monitor_totalFiles = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getFiles().size();
        Component notFoundComponent = new Component();
        notFoundComponent.setName("Not Found");
        notFoundComponent.setSource(BomSource.SCA);
        this.currentBom.getCategory(DefaultCategory.UNDEFINED).addComponent(notFoundComponent);
        if (!this.configuration.isOnlyPackage()) {
            AtomicInteger counter = new AtomicInteger();
            Collection<List<FileElement>> filesToAsk = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getFiles().stream().collect(Collectors.groupingBy(e -> counter.getAndIncrement() / 20)).values();
            Asyncs.waiting(filesToAsk.stream().map(files -> CompletableFuture.runAsync(() -> this.searchFingerprints(files), this.executor)));
        }
        new ArrayList<Snippet>(this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getSnippets()).forEach(snippet -> {
            Component newComponent = this.currentBom.getCategory(DefaultCategory.OPENSOURCE).getOrCreateComponent(this.scanLevel.equals((Object)ScaScanOptions.ScaLevelType.OS_DETECT) ? "Found in SCA" : snippet.getName(), this.scanLevel.equals((Object)ScaScanOptions.ScaLevelType.OS_DETECT) ? null : snippet.getScaProject(), BomSource.SCA, true);
            newComponent.setSource(BomSource.SCA);
            snippet.move(newComponent);
            if (snippet.getScaVersion() != null) {
                newComponent.setVersion(snippet.getScaVersion());
            }
        });
        List<Component> osComponents = this.currentBom.getCategory(DefaultCategory.OPENSOURCE).getComponents().stream().filter(c -> c.getSource().equals((Object)BomSource.SCA)).toList();
        this.monitor_totalComps = osComponents.size();
        Asyncs.waiting(osComponents.stream().map(osComponent -> CompletableFuture.runAsync(() -> this.searchComponent(osComponent), this.executor)));
        List<String> distinctVulnerabilities = osComponents.stream().map(Component::getVulnerabilities).flatMap(Collection::stream).map(Vulnerability::getVId).distinct().toList();
        Asyncs.waiting(distinctVulnerabilities.stream().map(vulnerability -> CompletableFuture.runAsync(() -> this.searchVulnerability(vulnerability), this.executor)));
        osComponents.stream().filter(c -> c.getSource().equals((Object)BomSource.LOCAL) && c.getFiles().isEmpty()).forEach(c -> c.move(this.currentBom.getCategory(DefaultCategory.UNDEFINED)));
        this.info("Found %d components open source", new Object[]{this.currentBom.getComponentsFromSource(BomSource.SCA).stream().filter(c -> c.getCategory().getType().equals((Object)DefaultCategory.OPENSOURCE)).count()});
        this.info("End SCA scanner", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterCommonComponent(Component component, ScaProject projectData) {
        lock.lock();
        try {
            if (ScaFilters.filterGitStars((Component)component, (ScaProject)projectData) || ScaFilters.filterOneFile((Component)component, (ScaProject)projectData) || ScaFilters.filterCommonPaths((Component)component, (ScaProject)projectData)) {
                Component scaFound = this.currentBom.getCategory(DefaultCategory.OPENSOURCE).getOrCreateComponent("Found in SCA", null, BomSource.SCA, true);
                scaFound.setSource(BomSource.SCA);
                new ArrayList<FileElement>(component.getFiles()).forEach(f -> f.move(scaFound));
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void info(String format, Object ... objects) {
        this.log(LOGGER, ScaScanner.class, this.currentBom, format, objects);
    }

    private void searchFingerprints(List<FileElement> files) {
        List fingerprints = this.dataAPI.getFingerprints(files);
        if (fingerprints != null) {
            fingerprints.forEach(f -> this.manageFoundFingerprint(files, f));
            this.manageNotFoundFingerprint(files);
        }
        this.configuration.notify((Event)BomCreatorEvents.read((Scanner)this, (Double)((double)files.size() * 100.0 / this.monitor_totalFiles * 0.6)));
    }

    private void searchComponent(Component osComponent) {
        Map pathVersions = this.filterVersionsByPath(osComponent);
        try {
            ScaProject result = this.dataAPI.getComponent(osComponent);
            if (result != null) {
                if (result.getHref() != null) {
                    String next = result.getHref().getVersionsFull();
                    while (next != null) {
                        ScaProjectVersionList versionList = this.dataAPI.getComponentVersions(next);
                        result.addVersions(versionList.getVersions());
                        next = Optional.ofNullable(versionList.getHref()).map(ScaHref::getNext).orElse(null);
                    }
                }
                if (this.scanLevel.equals((Object)ScaScanOptions.ScaLevelType.COMMON_DETECT)) {
                    this.filterCommonComponent(osComponent, result);
                }
                if (!osComponent.isEmpty()) {
                    this.manageScaComponent(osComponent, pathVersions, result);
                }
            } else {
                osComponent.setSource(BomSource.LOCAL);
                osComponent.setScaId(null);
                if (osComponent.getVersion() != null && !osComponent.getVersion().isEmpty()) {
                    osComponent.addToAllVersions(osComponent.getVersion(), Long.valueOf(Instant.now().toEpochMilli()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to fetch component details", (Throwable)e);
            osComponent.setSource(BomSource.LOCAL);
        }
        this.configuration.notify((Event)BomCreatorEvents.read((Scanner)this, (Double)(100.0 / this.monitor_totalComps * 0.4)));
    }

    private void searchVulnerability(String vulnerability) {
        Optional dbVulnerability = this.dbFetcher.getVulnerability(vulnerability);
        if (dbVulnerability.isEmpty()) {
            try {
                ScaVulnerability result = this.dataAPI.getVulnerability(vulnerability);
                if (result != null) {
                    Vulnerability newVulnerability = Vulnerability.fromScaVulnerability((ScaVulnerability)result);
                    this.currentBom.addVulnerability(newVulnerability);
                }
            }
            catch (Exception e) {
                LOGGER.warn("failed to fetch vulnerability details", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageFoundFingerprint(List<FileElement> files, ScaFingerprint fingerprint) {
        try {
            lock.lock();
            FileElement currentFile = files.stream().filter(f -> f.getSha256().equals(fingerprint.getSha256())).findAny().orElseThrow(RuntimeException::new);
            currentFile.setProjectName(fingerprint.getStandardizedProjectName());
            currentFile.setScaProject(fingerprint.getProject().getName());
            currentFile.setScaVersion(fingerprint.getProject().getVersion() != null ? fingerprint.getProject().getVersion() : "");
            Component newComponent = this.currentBom.getCategory(DefaultCategory.OPENSOURCE).getOrCreateComponent(this.scanLevel.equals((Object)ScaScanOptions.ScaLevelType.OS_DETECT) ? "Found in SCA" : currentFile.getProjectName(), this.scanLevel.equals((Object)ScaScanOptions.ScaLevelType.OS_DETECT) ? null : currentFile.getScaProject(), BomSource.SCA, true);
            newComponent.setSource(BomSource.SCA);
            if (newComponent.getFiles().isEmpty()) {
                this.info("Found new component %s", new Object[]{newComponent.getName()});
            }
            currentFile.move(newComponent);
        }
        finally {
            lock.unlock();
        }
    }

    private void manageNotFoundFingerprint(List<FileElement> files) {
        try {
            lock.lock();
            Component notFoundComponent = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Found", null);
            notFoundComponent.setSource(BomSource.LOCAL);
            files.stream().filter(f -> f.getComponent().getName().equals("Not Scanned")).forEach(f -> f.move(notFoundComponent));
        }
        finally {
            lock.unlock();
        }
    }

    private Map<String, Set<String>> filterVersionsByPath(Component component) {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        component.getFiles().stream().collect(Collectors.groupingBy(FileElement::getScaVersion, Collectors.mapping(f -> f.getFileNode().getParent().getPath(), Collectors.collectingAndThen(Collectors.toSet(), arg_0 -> ((ScaScanner)this).findMinimalPath(arg_0))))).entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet()))).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            Optional<String> keyMatch = result.keySet().stream().filter(r -> ((String)e.getKey()).startsWith((String)r) || r.startsWith((String)e.getKey())).findAny();
            if (keyMatch.isPresent()) {
                if (keyMatch.get().length() <= ((String)e.getKey()).length()) {
                    ((Set)result.get(keyMatch.get())).addAll((Collection)e.getValue());
                } else {
                    result.put((String)e.getKey(), (Set)e.getValue());
                    ((Set)result.get(e.getKey())).addAll((Collection)result.remove(keyMatch.get()));
                }
            } else {
                result.put((String)e.getKey(), (Set)e.getValue());
            }
        });
        return result;
    }

    private String findNewestVersion(Set<String> versions, ScaProject projectData) {
        return projectData.getVersions().stream().filter(v -> versions.contains(v.getName())).max(Comparator.comparingLong(ScaProjectVersion::getReleaseDate)).orElse(new ScaProjectVersion()).getName();
    }

    private void manageScaComponent(Component component, Map<String, Set<String>> pathVersions, ScaProject projectData) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(component);
        if (!pathVersions.isEmpty()) {
            component.setVersion(this.findNewestVersion((Set)((Map.Entry)pathVersions.entrySet().stream().findFirst().get()).getValue(), projectData));
            if (pathVersions.size() > 1) {
                pathVersions.entrySet().stream().skip(1L).forEach(pv -> {
                    Component newComponent = new Component();
                    newComponent.setName(component.getName());
                    newComponent.setSource(component.getSource());
                    newComponent.setVersion(this.findNewestVersion((Set)pv.getValue(), projectData));
                    component.getCategory().addComponent(newComponent);
                    component.getFiles().stream().filter(f -> f.getFileNode().getPath().startsWith((String)pv.getKey())).toList().forEach(f -> f.move(newComponent));
                    components.add(newComponent);
                });
            }
        }
        components.forEach(c -> {
            if (this.useLicenseAtVersionLevel(c, projectData)) {
                projectData.getVersions().stream().filter(v -> v.getName().equals(c.getVersion())).findFirst().map(ScaProjectVersion::getLicenses).ifPresent(sl -> sl.forEach(license -> c.addLicense(new License(license))));
            } else {
                Opt.ofNullable((Object)projectData.getLicenses()).ifPresent(ls -> ls.forEach(license -> c.addLicense(new License(license))));
            }
            c.addReference(projectData.getUrl());
            if (projectData.getHomepage() != null) {
                c.addReference(projectData.getHomepage());
            }
            c.getFiles().forEach(f -> c.getLicenses().forEach(arg_0 -> ((FileElement)f).addLicense(arg_0)));
            c.setPath(this.findMinimalPath(c.getFiles().stream().map(FileElement::getFileNode).map(FileNode::getPath).collect(Collectors.toSet())));
            if (c.getVersion() != null) {
                projectData.getVersions().stream().filter(v -> v.getName().equals(c.getVersion())).findFirst().map(ScaProjectVersion::getVulnerabilities).ifPresent(sv -> sv.forEach(vul -> c.addVulnerability(Vulnerability.builder().vId(vul).build())));
            }
            if (c.getVersion() != null) {
                projectData.getVersions().stream().filter(v -> v.getName().equals(c.getVersion())).findFirst().map(ScaProjectVersion::getCopyrights).map(FileParsingTool::cleanCopyright).ifPresent(arg_0 -> ((Component)c).setCopyrights(arg_0));
            }
            c.setScaId(projectData.getName());
            c.setDescription(projectData.getDescription());
            c.setRepositoryType(projectData.getRepositoryType());
            c.setRepository(projectData.getRepository());
            Opt.ofNullable((Object)projectData.getTopics()).ifPresent(d -> d.forEach(arg_0 -> ((Component)c).addTopic(arg_0)));
            Opt.ofNullable((Object)projectData.getLanguages()).ifPresent(l -> l.forEach(arg_0 -> ((Component)c).addLanguage(arg_0)));
            projectData.getVersions().forEach(v -> c.addToAllVersions(v.getName(), Long.valueOf(v.getReleaseDate())));
            c.getAllVersions().entrySet().stream().max(Map.Entry.comparingByValue()).ifPresent(v -> c.setLatestVersion((String)v.getKey()));
            if (c.getVersion() != null && !c.getVersion().isEmpty() && !c.getAllVersions().containsKey(c.getVersion())) {
                c.addToAllVersions(c.getVersion(), Long.valueOf(Instant.now().toEpochMilli()));
            }
            c.setUpToDate(ObsolescenceComputer.compute((String)c.getVersion(), (String)c.getLatestVersion(), (Map)c.getAllVersions()).name());
        });
    }

    private boolean useLicenseAtVersionLevel(Component component, ScaProject project) {
        if (component.getVersion() == null || component.getVersion().isEmpty()) {
            return false;
        }
        return project.getVersions().stream().map(ScaProjectVersion::getLicenses).flatMap(Collection::stream).findFirst().isPresent();
    }
}

