/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner;

import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import java.util.ArrayList;

public class NoScaScanner
extends Scanner {
    private final Bom currentBom;
    private final boolean hasLocalScanner;

    public NoScaScanner(Bom currentBom, boolean noLocalScanner, BomWizardConfiguration configuration) {
        super(null, configuration);
        this.currentBom = currentBom;
        this.hasLocalScanner = noLocalScanner;
    }

    public void scan() {
        Component notScanned = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL);
        if (notScanned != null) {
            ArrayList snippets = new ArrayList(notScanned.getSnippets());
            snippets.forEach(s -> {
                Component newComponent = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getOrCreateComponent(s.getName(), s.getScaProject(), BomSource.LOCAL, false);
                newComponent.setSource(BomSource.LOCAL);
                s.move(newComponent);
                if (s.getScaVersion() != null) {
                    newComponent.setVersion(s.getScaVersion());
                }
                newComponent.addSnippet(s);
            });
            if (this.hasLocalScanner) {
                Component notFoundComponent = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getOrCreateComponent("Not Found", null, null, false);
                notFoundComponent.setSource(BomSource.LOCAL);
                ArrayList files = new ArrayList(this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getFiles());
                files.forEach(f -> f.move(notFoundComponent));
            }
        }
    }
}

