/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner;

import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.HlCsvScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.analyzer.structure.FileElement;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.slf4j.Logger;

public class HlCsvScanner
extends Scanner {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(HlCsvScanner.class);
    private final Bom bom;
    private String hlRootFolder;
    private final Map<Snippet, String> frameworks;
    private final Map<String, FileNode> filenodes;

    public HlCsvScanner(Bom bom, BomWizardConfiguration configuration) {
        super(null, configuration);
        this.bom = bom;
        this.hlRootFolder = "";
        this.frameworks = new HashMap();
        this.filenodes = new HashMap();
    }

    public void scan() {
        this.configuration.notify((Event)BomCreatorEvents.scan((Scanner)this));
        this.info("Start HL-CSV scanner", new Object[0]);
        this.bom.setRootNode(new FileNode("", FileNode.FileNodeType.FOLDER, null));
        this.parseZipFile(this.configuration.getSourcePath());
        this.bom.setNumberOfFiles((long)this.bom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getFiles().size());
        int nbFrameworks = this.bom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getSnippets().size();
        this.info("Found %d files and %d frameworks", new Object[]{this.bom.getNumberOfFiles(), nbFrameworks});
        this.info("End HL-CSV scanner", new Object[0]);
        this.configuration.notify((Event)Event.finish(this.getClass()));
    }

    private void parseZipFile(String filename) {
        this.info("Scanning zip file %s", new Object[]{filename});
        try (ZipFile zip = new ZipFile(filename);){
            this.hlRootFolder = this.detectHlRootFolder(zip.stream().map(ZipEntry::getName).collect(Collectors.toList()));
            ((Stream)zip.stream().sequential()).forEach(entry -> {
                this.info("parsing zip entry %s", new Object[]{entry.getName()});
                Opt.ofNullable((Object)this.getCsvType(entry.getName())).ifPresent(type -> {
                    try {
                        this.parseCsvStream(zip.getInputStream((ZipEntry)entry), type);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                this.configuration.notify((Event)BomCreatorEvents.read((Scanner)this, (Double)(100.0 / (double)zip.size())));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.info("Link frameworks to file nodes and save.", new Object[0]);
        Component notScanned = this.bom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL);
        this.frameworks.forEach((framework, path) -> {
            if (this.filenodes.containsKey(path)) {
                framework.setFromFile((FileNode)this.filenodes.get(path));
            }
            notScanned.addSnippet(framework);
        });
    }

    private void parseCsvStream(InputStream stream, CsvType type) throws IOException {
        Component notScannedComponent = this.bom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL);
        BufferedReader csvReader = new BufferedReader(new InputStreamReader(stream));
        AtomicBoolean started = new AtomicBoolean(false);
        ((Stream)csvReader.lines().sequential()).filter(l -> !l.isEmpty() && !l.startsWith("#")).forEach(l -> {
            if (started.get()) {
                String[] csvElements = l.split(";");
                Opt.of((Object)csvElements[type.namePosition]).map(p -> this.cleanFilePath(p, type)).ifPresent(p -> {
                    if (type.equals((Object)CsvType.FRAMEWORK)) {
                        this.parseHlFramework(l);
                    } else {
                        FileNode fileNode = this.bom.getRootNode().findOrCreate(p);
                        FileElement fe = new FileElement();
                        fe.setFileNode(fileNode);
                        fe.setSha256(csvElements[type.hashPosition]);
                        notScannedComponent.addFile(fe);
                        this.filenodes.put(fileNode.getPath(), fileNode);
                    }
                });
            } else if (l.startsWith(type.startPattern)) {
                started.set(true);
            }
        });
        csvReader.close();
    }

    private void parseHlFramework(String line) {
        String[] elts = line.split(";");
        if (elts.length == 17 && elts[11].isEmpty()) {
            Snippet framework = Snippet.builder().name(elts[0]).build();
            switch (elts[1].toLowerCase()) {
                case "java": {
                    framework.setName(elts[0] + ":" + elts[6]);
                    framework.setScaProject(elts[0] + ":" + elts[6]);
                    break;
                }
                case "typescript": 
                case "js": {
                    framework.setScaProject(elts[0] + ".npm");
                    break;
                }
                case "php": {
                    framework.setScaProject(elts[0] + ".pkg");
                    break;
                }
                case "python": {
                    framework.setScaProject(elts[0] + ".py");
                    break;
                }
                case "ruby": {
                    framework.setScaProject(elts[0] + ".rb");
                    break;
                }
                case "cs": {
                    framework.setScaProject(elts[0] + ".NET");
                    break;
                }
                default: {
                    framework.setScaProject(elts[0]);
                }
            }
            if (!elts[7].isEmpty()) {
                framework.setScaVersion(elts[7]);
            } else if (!elts[3].isEmpty()) {
                framework.setScaVersion(elts[3].replaceAll("[~^]", ""));
            }
            this.frameworks.put(framework, "/" + this.cleanFilePath(elts[16], CsvType.SNIPPET));
        }
    }

    private String detectHlRootFolder(List<String> filenames) {
        Pattern detector = Pattern.compile("(.+)_[0-9]{8}_[0-9]{4}_[0-9]+\\.csv");
        for (String f : filenames) {
            Matcher m = detector.matcher(f);
            if (!m.lookingAt()) continue;
            return m.group(1).substring(0, m.group(1).lastIndexOf("."));
        }
        return "";
    }

    private CsvType getCsvType(String entry) {
        return entry.startsWith("BinaryLibraries") ? CsvType.BINARY : (entry.startsWith("framework.validated") ? CsvType.FRAMEWORK : (entry.endsWith(".CloudReady.csv") ? null : (entry.endsWith(".ThirdParties.csv") ? CsvType.THIRDPARTY : CsvType.STANDARD)));
    }

    private void info(String format, Object ... objects) {
        this.log(LOGGER, HlCsvScanner.class, this.bom, format, objects);
    }

    private String cleanFilePath(String path, CsvType type) {
        switch (type.ordinal()) {
            case 0: {
                if (!path.contains("::")) break;
                if (path.endsWith("::root")) {
                    return path.substring(0, path.length() - 6);
                }
                return null;
            }
            case 2: 
            case 4: {
                if (!path.contains(this.hlRootFolder)) break;
                return path.substring(path.indexOf(this.hlRootFolder) + this.hlRootFolder.length() + 1);
            }
        }
        return path;
    }
}

