/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner;

import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.exception.BomScanException;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.sshd.JGitKeyCache;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.SshdSessionFactoryBuilder;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;

public class GitScanner
extends Scanner {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(GitScanner.class);
    private final Bom scanning;
    private final SshSessionFactory sshSessionFactory = new SshdSessionFactoryBuilder().setPreferredAuthentications("publickey,password").setHomeDirectory(FS.DETECTED.userHome()).setSshDirectory(new File(FS.DETECTED.userHome(), ".ssh")).build((KeyCache)new JGitKeyCache());

    public GitScanner(Bom scanning, BomWizardConfiguration configuration) {
        super(null, configuration);
        this.scanning = scanning;
    }

    public void scan() {
        this.configuration.notify((Event)BomCreatorEvents.scan((Scanner)this));
        this.info("Start GIT scanner", new Object[0]);
        try {
            File gitTempFolder = Files.createTempDirectory("gcl", new FileAttribute[0]).toFile();
            Git git = ((CloneCommand)Git.cloneRepository().setTransportConfigCallback(transport -> {
                if (transport instanceof SshTransport) {
                    ((SshTransport)transport).setSshSessionFactory(this.sshSessionFactory);
                }
            })).setDirectory(gitTempFolder).setURI(this.scanning.getSourcePath()).call();
            if (this.configuration.getSourceOptions() != null && this.configuration.getSourceOptions().containsKey("rev")) {
                git.checkout().setName((String)this.configuration.getSourceOptions().get("rev")).call();
            }
            this.scanning.setLocalSourcePath(gitTempFolder.getAbsolutePath());
            this.info("End GIT scanner", new Object[0]);
            this.configuration.notify((Event)Event.finish(this.getClass()));
        }
        catch (IOException | GitAPIException e) {
            throw new BomScanException("git_scanner_error", "Unexpected error whilst retrieving GIT project", e);
        }
    }

    private void info(String format, Object ... objects) {
        this.log(LOGGER, GitScanner.class, this.scanning, format, objects);
    }
}

