/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner;

import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.FileFilter;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.FileScanOptions;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.ScanOptions;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.analyzer.structure.FileElement;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.tools.FileFilterTool;
import com.castsoftware.sca.scar.server.analyzer.tools.FileParsingTool;
import com.castsoftware.sca.scar.server.analyzer.tools.ParsedFileData;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;

public class FileScanner
extends Scanner {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(FileScanner.class);
    private final AtomicInteger countFolder = new AtomicInteger(0);
    private final AtomicInteger countFile = new AtomicInteger(0);
    private final Executor executor;
    private final Bom scanning;

    public FileScanner(Executor executor, Bom scanning, BomWizardConfiguration configuration) {
        super((ScanOptions)configuration.getFileOptions(), configuration);
        this.executor = executor;
        this.scanning = scanning;
    }

    public void scan() {
        this.configuration.notify((Event)BomCreatorEvents.scan((Scanner)this));
        if (this.getScanning().getLocalSourcePath() == null) {
            this.getScanning().setLocalSourcePath(this.getScanning().getSourcePath());
        }
        this.info("count files", new Object[0]);
        this.scanning.setNumberOfFiles(this.getNumberOfFiles(this.getScanning().getLocalSourcePath()));
        if (this.scanning.getNumberOfFiles() > -1L) {
            this.info("start scan files", new Object[0]);
            this.scanning.setRootNode(this.computeFileNodeTree(this.getScanning().getLocalSourcePath()));
            Component notScannedComponent = this.scanning.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL);
            this.addFileElement(notScannedComponent, this.scanning.getRootNode(), this.getScanning().getLocalSourcePath());
            this.info("end scan files: Find %d Folder, %d Files", new Object[]{this.countFolder.get(), this.countFile.get()});
            this.info("end scan files", new Object[0]);
        }
    }

    private Bom getScanning() {
        return this.scanning;
    }

    private long getNumberOfFiles(String sourceFolderPath) {
        try {
            return ((Stream)Files.walk(Paths.get(sourceFolderPath, new String[0]), new FileVisitOption[0]).parallel()).filter(p -> !p.toFile().isDirectory()).filter(p -> this.shouldKeepFile(new File(p.toString()))).count();
        }
        catch (IOException ignored) {
            this.info("File folder not found", new Object[0]);
            return -1L;
        }
    }

    private void info(String format, Object ... objects) {
        this.log(LOGGER, FileScanner.class, this.scanning, format, objects);
    }

    private FileNode computeFileNodeTree(String folder) {
        FileNode root = new FileNode("", FileNode.FileNodeType.FOLDER, null);
        try {
            Files.walkFileTree(Paths.get(folder, new String[0]), (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (FileNode)root.getChildren().get(0);
    }

    private boolean shouldKeepFile(File file) {
        FileScanOptions options = (FileScanOptions)this.getScanOptions();
        if (options == null || !options.hasFilters()) {
            return true;
        }
        boolean filtered = this.matchFilter(file, options.getFilters());
        if (filtered && options.hasExceptions()) {
            filtered = !this.matchFilter(file, options.getExceptions());
        }
        return Boolean.logicalXor(filtered, options.getFilters().isExclude());
    }

    private boolean matchFilter(File file, FileFilter filters) {
        AtomicBoolean filtered = new AtomicBoolean(false);
        filters.getLineFilters().forEach((filter, list) -> filtered.set(filtered.get() || list.stream().map(data -> FileFilterTool.filter((FileFilter.LineFilter)filter, (File)file, (Object)data)).reduce(Boolean::logicalOr).orElseThrow(RuntimeException::new) != false));
        return filtered.get();
    }

    private void addFileElement(Component component, FileNode root, String folder) {
        this.info("add Files to %s", new Object[]{component.getName()});
        AtomicInteger counter = new AtomicInteger(0);
        List<CompletableFuture> futures = root.stream().filter(FileNode::isFile).peek(n -> counter.incrementAndGet()).map(n -> CompletableFuture.supplyAsync(this.computeFileElement(folder, n), this.executor)).toList();
        futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).forEach(arg_0 -> ((Component)component).addFile(arg_0));
        this.info("added %d Files to %s", new Object[]{counter.get(), component.getName()});
    }

    private Supplier<FileElement> computeFileElement(String folder, FileNode node) {
        return () -> {
            FileElement result = null;
            File f = new File(folder + node.getPath());
            try (ParsedFileData hs = FileParsingTool.parseFile((File)f);){
                result = new FileElement();
                result.setFileNode(node);
                result.setSize(f.length());
                result.setSha256(hs.getSha256());
                result.setSha1(hs.getSha1());
                result.setMd5(hs.getMd5());
                result.setCopyrights(hs.getCopyrights());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.configuration.notify((Event)BomCreatorEvents.read((Scanner)this, (Double)(100.0 / (double)this.scanning.getNumberOfFiles())));
            return result;
        };
    }
}

