/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner;

import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.CycloneDxScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxComponent;
import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxComponentExtRef;
import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxLicense;
import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxLicenseChoice;
import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxProperty;
import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxSbom;
import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxVulnerability;
import com.castsoftware.sca.scar.server.analyzer.scanner.cyclonedx.domain.CdxVulnerabilityRating;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Category;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.analyzer.structure.FileElement;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.License;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.structure.Vulnerability;
import com.castsoftware.sca.scar.server.bom.exception.CycloneDxParsingException;
import com.castsoftware.sca.scar.server.bom.handler.AnalyzerBomFetcher;
import com.castsoftware.sca.scar.server.cyclonedx.domain.CdxFileProperty;
import com.castsoftware.sca.scar.server.cyclonedx.domain.CdxLibraryProperty;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaVulnerability;
import com.castsoftware.sca.scar.server.sam.requester.DataApiRequester;
import com.castsoftware.sca.scar.server.util.Fields;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityLevel;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.Normalizer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.vulnerability.Vulnerability;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class CycloneDxScanner
extends Scanner {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(CycloneDxScanner.class);
    private static final String EXT_JSON = "json";
    private static final String CDX_FILE = "file";
    private static final String CDX_LIBRARY = "library";
    private static final String DEFAULT_PACKAGE_FILE_NAME = "SBOM-packages-source";
    private final Bom bom;
    private final AnalyzerBomFetcher dbFetcher;
    private final DataApiRequester dataApiRequester;

    public CycloneDxScanner(Bom bom, BomWizardConfiguration configuration, AnalyzerBomFetcher dbFetcher, DataApiRequester dataApiRequester) {
        super(null, configuration);
        this.bom = bom;
        this.dbFetcher = dbFetcher;
        this.dataApiRequester = dataApiRequester;
    }

    public void scan() {
        this.configuration.notify((Event)BomCreatorEvents.scan((Scanner)this));
        LOGGER.info("Start CycloneDX scanner");
        this.processBom(this.parseCycloneDXBom());
    }

    private CdxSbom parseCycloneDXBom() {
        String pathAsString = this.configuration.getSourcePath();
        Path path = Path.of(pathAsString, new String[0]);
        File file = path.toFile();
        this.configuration.notify((Event)BomCreatorEvents.cdxParsing());
        LOGGER.info("Parsing Cyclone-DX file...");
        String extension = FilenameUtils.getExtension((String)String.valueOf(path.getFileName()));
        try {
            return "json".equals(extension) ? this.parseJson(file) : this.parseXml(file);
        }
        catch (Exception e) {
            throw new CycloneDxParsingException((Throwable)e);
        }
    }

    private CdxSbom parseJson(File jsonFile) throws IOException {
        JsonMapper jsonMapper = new JsonMapper();
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        return (CdxSbom)jsonMapper.readValue(this.normalizeFileContent(jsonFile), CdxSbom.class);
    }

    private CdxSbom parseXml(File xmlFile) throws IOException {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        xmlMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        return (CdxSbom)xmlMapper.readValue(this.normalizeFileContent(xmlFile), CdxSbom.class);
    }

    private String normalizeFileContent(File file) throws IOException {
        return Normalizer.normalize(new String(Files.readAllBytes(file.toPath())), Normalizer.Form.NFD);
    }

    private void processBom(@NonNull CdxSbom cdxSbom) {
        this.configuration.notify((Event)BomCreatorEvents.cdxMapping());
        LOGGER.info("Mapping Cyclone-DX data to SBOM...");
        FileNode rootNode = new FileNode();
        rootNode.setType(FileNode.FileNodeType.FOLDER);
        this.bom.setRootNode(rootNode);
        List cdxComponents = cdxSbom.getComponents();
        if (CollectionUtils.isEmpty((Collection)cdxComponents)) {
            return;
        }
        Map vulnerabilityLookup = this.fetchVulnerabilities(cdxSbom);
        for (CdxComponent cdxComponent : cdxComponents) {
            this.processLibrary(cdxComponent, cdxSbom, rootNode, vulnerabilityLookup);
        }
    }

    private Map<String, Vulnerability> fetchVulnerabilities(@NonNull CdxSbom cdxSbom) {
        List vulnerabilities = cdxSbom.getVulnerabilities();
        if (vulnerabilities == null || vulnerabilities.isEmpty()) {
            return Collections.emptyMap();
        }
        return vulnerabilities.stream().map(this.mapVulnerabilityFn(this.bom)).collect(Collectors.toMap(Vulnerability::getVId, Function.identity()));
    }

    private @NonNull Function<CdxVulnerability, Vulnerability> mapVulnerabilityFn(Bom bom) {
        return cdxV -> {
            Vulnerability existingVul = this.findExistingVulnerability(cdxV.getId());
            if (existingVul != null) {
                return existingVul;
            }
            Vulnerability scaVul = this.findScaDataApiVulnerability(cdxV.getId());
            if (scaVul != null) {
                bom.addVulnerability(scaVul);
                return scaVul;
            }
            Vulnerability newVul = this.mapNewVulnerability(cdxV);
            bom.addVulnerability(newVul);
            return newVul;
        };
    }

    private Vulnerability findExistingVulnerability(String vulnerabilityId) {
        return this.dbFetcher.getVulnerability(vulnerabilityId).map(arg_0 -> this.fromVertex(arg_0)).orElse(null);
    }

    private @NonNull Vulnerability fromVertex(@NonNull VulnerabilityVertex vertex) {
        Vulnerability v = Vulnerability.builder().vId(vertex.getVId()).build();
        Fields.field((String)vertex.getSeverity(), arg_0 -> ((Vulnerability)v).setSeverity(arg_0));
        Fields.field((Collection)vertex.getCwes(), arg_0 -> ((Vulnerability)v).setCwes(arg_0));
        Fields.field((String)vertex.getDescription(), arg_0 -> ((Vulnerability)v).setDescription(arg_0));
        Fields.field((Object)vertex.getPublished().toEpochMilli(), arg_0 -> ((Vulnerability)v).setPublished(arg_0), ts -> ts > 0L);
        Fields.field((Collection)vertex.getReferences(), arg_0 -> ((Vulnerability)v).setReferences(arg_0));
        Fields.field((String)vertex.getVector2(), arg_0 -> ((Vulnerability)v).setCvss2(arg_0));
        Fields.field((String)vertex.getVector3(), arg_0 -> ((Vulnerability)v).setCvss3(arg_0));
        Fields.field((String)String.valueOf(vertex.getScores2().get("BASE")), arg_0 -> ((Vulnerability)v).setScore2(arg_0));
        Fields.field((String)String.valueOf(vertex.getScores3().get("BASE")), arg_0 -> ((Vulnerability)v).setScore3(arg_0));
        return v;
    }

    private @NonNull Vulnerability findScaDataApiVulnerability(String vulnerabilityId) {
        ScaVulnerability scaVulnerability = this.dataApiRequester.getVulnerability(vulnerabilityId);
        return scaVulnerability != null ? this.fromScaVulnerability(scaVulnerability) : null;
    }

    private @NonNull Vulnerability fromScaVulnerability(@NonNull ScaVulnerability scaVul) {
        Vulnerability v = Vulnerability.builder().vId(scaVul.getName()).build();
        Fields.field((String)scaVul.getSeverity(), arg_0 -> ((Vulnerability)v).setSeverity(arg_0));
        Fields.field((Collection)scaVul.getCwes(), arg_0 -> ((Vulnerability)v).setCwes(arg_0));
        Fields.field((String)scaVul.getDescription(), arg_0 -> ((Vulnerability)v).setDescription(arg_0));
        Fields.field((Object)scaVul.getPublished(), arg_0 -> ((Vulnerability)v).setPublished(arg_0), ts -> ts > 0L);
        Fields.field((Collection)scaVul.getReferences(), arg_0 -> ((Vulnerability)v).setReferences(arg_0));
        Fields.field((String)scaVul.getCvss2(), arg_0 -> ((Vulnerability)v).setCvss2(arg_0));
        Fields.field((String)scaVul.getCvss3(), arg_0 -> ((Vulnerability)v).setCvss3(arg_0));
        Fields.field((String)scaVul.getScore2(), arg_0 -> ((Vulnerability)v).setScore2(arg_0));
        Fields.field((String)scaVul.getScore3(), arg_0 -> ((Vulnerability)v).setScore3(arg_0));
        return v;
    }

    private @NonNull Vulnerability mapNewVulnerability(@NonNull CdxVulnerability cdxVul) {
        List references;
        List cwes;
        Vulnerability vul = Vulnerability.builder().vId(cdxVul.getId()).build();
        List ratings = cdxVul.getRatings();
        if (CollectionUtils.isNotEmpty((Collection)ratings)) {
            for (CdxVulnerabilityRating rating : ratings) {
                if (StringUtils.isNotEmpty((CharSequence)rating.getMethod())) {
                    String methodAsString = rating.getMethod().toUpperCase();
                    Double score = rating.getScore();
                    if (Vulnerability.Rating.Method.CVSSV2.name().equals(methodAsString)) {
                        if (score != null) {
                            vul.setScore2("b:" + score);
                        }
                        Fields.field((String)rating.getVector(), arg_0 -> ((Vulnerability)vul).setCvss2(arg_0));
                    } else if (Vulnerability.Rating.Method.CVSSV3.name().equals(methodAsString) || Vulnerability.Rating.Method.CVSSV31.name().equals(methodAsString)) {
                        if (rating.getScore() != null) {
                            vul.setScore3("b:" + score);
                        }
                        Fields.field((String)rating.getVector(), arg_0 -> ((Vulnerability)vul).setCvss3(arg_0));
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)rating.getSeverity()) || !EnumUtils.isValidEnum(VulnerabilityLevel.class, (String)rating.getSeverity().toUpperCase())) continue;
                vul.setSeverity(rating.getSeverity().toUpperCase());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)cdxVul.getPublished())) {
            vul.setPublished(Long.valueOf(Instant.parse(cdxVul.getPublished()).toEpochMilli()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(cwes = cdxVul.getCwes()))) {
            List formattedCwes = cwes.stream().map(cwe -> "CWE-" + cwe).collect(Collectors.toList());
            vul.setCwes(formattedCwes);
        }
        if (StringUtils.isNotEmpty((CharSequence)cdxVul.getDescription())) {
            vul.setDescription(cdxVul.getDescription());
        }
        if (CollectionUtils.isNotEmpty((Collection)(references = cdxVul.getReferences()))) {
            List urls = references.stream().map(ref -> ref.getSource().getUrl()).collect(Collectors.toList());
            vul.setReferences(urls);
        }
        return vul;
    }

    private void processLibrary(@NonNull CdxComponent cdxComponent, CdxSbom cdxSbom, FileNode rootNode, Map<String, Vulnerability> vulnerabilitiesById) {
        List extRefs;
        CdxLicenseChoice licenseChoice;
        List vulnerabilities;
        Component component = new Component();
        component.setSource(BomSource.IMPORT);
        component.setName(cdxComponent.getName());
        if (StringUtils.isNotBlank((CharSequence)cdxComponent.getVersion())) {
            component.setVersion(cdxComponent.getVersion().trim());
        }
        component.setCopyrights(cdxComponent.getCopyright());
        component.setDescription(cdxComponent.getDescription());
        String cdxComponentRef = cdxComponent.getBomRef();
        if (StringUtils.isNotBlank((CharSequence)cdxComponentRef) && CollectionUtils.isNotEmpty((Collection)(vulnerabilities = cdxSbom.getVulnerabilities()))) {
            vulnerabilities.stream().filter(cdxVulnerability -> {
                List affects = cdxVulnerability.getAffects();
                return affects != null && affects.stream().anyMatch(cdxAffect -> cdxComponentRef.equals(cdxAffect.getRef()));
            }).map(CdxVulnerability::getId).forEach(vulId -> {
                Vulnerability vulnerability = (Vulnerability)vulnerabilitiesById.get(vulId);
                if (vulnerability != null) {
                    component.addVulnerability(vulnerability);
                }
            });
        }
        if ((licenseChoice = cdxComponent.getLicenseChoice()) != null) {
            Set licenses = this.extractLicenses(licenseChoice);
            component.setLicenses(licenses);
        }
        if (CollectionUtils.isNotEmpty((Collection)(extRefs = cdxComponent.getExternalReferences()))) {
            List refs = cdxComponent.getExternalReferences().stream().map(CdxComponentExtRef::getUrl).collect(Collectors.toList());
            component.setReferences(refs);
        }
        FileNode componentNode = rootNode;
        if (cdxComponent.getProperties() != null) {
            for (CdxProperty prop : cdxComponent.getProperties()) {
                CdxLibraryProperty propType = CdxLibraryProperty.from((String)prop.getName());
                String propValue = StringUtils.trim((String)prop.getValue());
                if (propType == null || !StringUtils.isNotBlank((CharSequence)propValue)) continue;
                switch (1.$SwitchMap$com$castsoftware$sca$scar$server$cyclonedx$domain$CdxLibraryProperty[propType.ordinal()]) {
                    case 1: {
                        String categoryName = propValue.toUpperCase();
                        Category category = this.bom.getCategories().stream().filter(cat -> cat.getType().name().equals(categoryName)).findFirst().orElseGet(() -> {
                            DefaultCategory defaultCategory = DefaultCategory.valueOf((String)categoryName);
                            Category newCategory = new Category(defaultCategory);
                            this.bom.addCategory(newCategory);
                            return newCategory;
                        });
                        category.addComponent(component);
                        component.setCategory(category);
                        break;
                    }
                    case 2: {
                        component.setRepository(propValue);
                        break;
                    }
                    case 3: {
                        component.setRepositoryType(propValue);
                        break;
                    }
                    case 4: {
                        component.setPath(propValue);
                        componentNode = this.setElementPath(propValue, componentNode);
                        break;
                    }
                    case 5: {
                        component.setLanguages(Arrays.asList(propValue.split(", ")));
                        break;
                    }
                    case 6: {
                        component.setTopics(Arrays.asList(propValue.split(", ")));
                        break;
                    }
                    case 7: {
                        component.setUpToDate(propValue);
                        break;
                    }
                    case 8: {
                        component.setLatestVersion(propValue);
                        break;
                    }
                    case 9: {
                        component.setAllVersions(this.extractVersionsFromString(propValue));
                        break;
                    }
                    case 10: {
                        component.setScaId(propValue);
                        break;
                    }
                    case 11: {
                        FileNode snippetNode = this.getComponentSnippetNode(propValue, rootNode);
                        component.getSnippets().add(this.createSnippet(component, snippetNode));
                    }
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)component.getPath())) {
            component.setPath("/");
        }
        if (component.getCategory() == null) {
            this.setUndefinedComponentCategory(component, this.bom);
        }
        String version = cdxComponent.getVersion();
        if (MapUtils.isEmpty((Map)component.getAllVersions()) && StringUtils.isNotBlank((CharSequence)version)) {
            component.setAllVersions(Map.of(version.trim(), 0L));
        }
        if (CollectionUtils.isNotEmpty((Collection)cdxComponent.getComponents())) {
            for (CdxComponent cdxElement : cdxComponent.getComponents()) {
                if ("file".equals(cdxElement.getType())) {
                    this.processFile(cdxElement, component, componentNode);
                    continue;
                }
                if (!"library".equals(cdxElement.getType())) continue;
                this.processLibrary(cdxElement, cdxSbom, rootNode, vulnerabilitiesById);
            }
        } else if (CollectionUtils.isEmpty((Collection)component.getSnippets())) {
            this.processSnippets(cdxComponent, component, rootNode);
        }
    }

    private Map<String, Long> extractVersionsFromString(@NonNull String versionsAsString) {
        return Arrays.stream(versionsAsString.split(", ")).map(version -> version.split(":", 2)).collect(Collectors.toMap(parts -> parts[0], parts -> ((String[])parts).length > 1 ? CycloneDxScanner.timestampFromString((String)parts[1]).longValue() : Instant.now().toEpochMilli()));
    }

    private static Long timestampFromString(String timestampAsString) {
        if (StringUtils.isNotBlank((CharSequence)timestampAsString) && timestampAsString.chars().allMatch(Character::isDigit)) {
            return Long.parseLong(timestampAsString);
        }
        return Instant.now().toEpochMilli();
    }

    private void processFile(@NonNull CdxComponent cdxFile, Component component, FileNode componentNode) {
        CdxLicenseChoice licenseChoice;
        FileElement fileElement = new FileElement();
        fileElement.setComponent(component);
        component.addFile(fileElement);
        Fields.field((String)cdxFile.getVersion(), arg_0 -> ((FileElement)fileElement).setScaVersion(arg_0));
        Fields.field((String)cdxFile.getCopyright(), arg_0 -> ((FileElement)fileElement).setCopyrights(arg_0));
        if (CollectionUtils.isNotEmpty((Collection)cdxFile.getHashes())) {
            cdxFile.getHashes().stream().filter(cdxHash -> StringUtils.isNotEmpty((CharSequence)cdxHash.getAlg())).forEach(cdxHash -> {
                String alg = cdxHash.getAlg().toUpperCase();
                String content = cdxHash.getContent();
                if (Hash.Algorithm.MD5.getSpec().equals(alg)) {
                    fileElement.setMd5(content);
                } else if (Hash.Algorithm.SHA1.getSpec().equals(alg)) {
                    fileElement.setSha1(content);
                } else if (Hash.Algorithm.SHA_256.getSpec().equals(alg)) {
                    fileElement.setSha256(content);
                }
            });
        }
        if ((licenseChoice = cdxFile.getLicenseChoice()) != null) {
            Set licenses = this.extractLicenses(licenseChoice);
            fileElement.setLicenses(licenses);
        }
        if (CollectionUtils.isNotEmpty((Collection)cdxFile.getProperties())) {
            for (CdxProperty prop : cdxFile.getProperties()) {
                CdxFileProperty propType = CdxFileProperty.from((String)prop.getName());
                if (propType == null) continue;
                switch (1.$SwitchMap$com$castsoftware$sca$scar$server$cyclonedx$domain$CdxFileProperty[propType.ordinal()]) {
                    case 1: {
                        this.setFilePath(componentNode, prop.getValue(), cdxFile, fileElement);
                        break;
                    }
                    case 2: {
                        fileElement.setSize(Long.parseLong(prop.getValue()));
                    }
                }
            }
        }
        if (fileElement.getFileNode() == null) {
            FileNode fileNode = new FileNode(cdxFile.getName(), FileNode.FileNodeType.FILE, componentNode);
            fileElement.setFileNode(fileNode);
        }
    }

    private void processSnippets(CdxComponent cdxComponent, Component component, @NonNull FileNode rootNode) {
        FileNode pakagesFileFileNode = rootNode.getChildren().stream().filter(fn -> "SBOM-packages-source".equals(fn.getName())).findFirst().map(fn -> (FileNode)fn.getChildren().get(0)).orElse(null);
        if (pakagesFileFileNode == null) {
            Component packagesComponent = new Component();
            packagesComponent.setName("SBOM-packages-source");
            packagesComponent.setSource(BomSource.IMPORT);
            packagesComponent.setPath("/");
            packagesComponent.setVersion("");
            this.setUndefinedComponentCategory(packagesComponent, this.bom);
            FileNode pakagesComponentFileNode = new FileNode("SBOM-packages-source", FileNode.FileNodeType.FOLDER, rootNode);
            pakagesFileFileNode = new FileNode(this.configuration.getSourcePath(), FileNode.FileNodeType.FILE, pakagesComponentFileNode);
            FileElement packagesFileElement = new FileElement();
            packagesFileElement.setFileNode(pakagesFileFileNode);
            packagesFileElement.setComponent(packagesComponent);
            packagesComponent.addFile(packagesFileElement);
        }
        String version = StringUtils.isNotBlank((CharSequence)cdxComponent.getVersion()) ? cdxComponent.getVersion().trim() : null;
        Snippet snippet = this.createSnippet(component.getName(), component.getName(), version, pakagesFileFileNode, component);
        component.getSnippets().add(snippet);
    }

    private void setUndefinedComponentCategory(Component component, @NonNull Bom bom) {
        bom.getCategories().stream().filter(cat -> DefaultCategory.UNDEFINED.equals((Object)cat.getType())).findFirst().or(() -> {
            Category category = new Category(DefaultCategory.UNDEFINED);
            bom.addCategory(category);
            return Optional.of(category);
        }).ifPresent(cat -> {
            cat.addComponent(component);
            component.setCategory(cat);
        });
    }

    private Set<License> extractLicenses(@NonNull CdxLicenseChoice licenseChoice) {
        List licenses = licenseChoice.getLicenses();
        if (licenses != null && !licenses.isEmpty()) {
            return this.licensesFromCdxLicenses(licenses);
        }
        if (StringUtils.isNotBlank((CharSequence)licenseChoice.getExpression())) {
            return this.licensesFromExpression(licenseChoice.getExpression());
        }
        return Sets.newHashSet();
    }

    private Set<License> licensesFromCdxLicenses(@NonNull List<CdxLicense> licenses) {
        return licenses.stream().map(CdxLicense::getSpdxId).filter(StringUtils::isNotBlank).map(License::new).collect(Collectors.toSet());
    }

    public Set<License> licensesFromExpression(@NonNull String expression) {
        return Arrays.stream(expression.replaceAll("[()]", "").split("(?i)\\b(AND|OR)\\b")).map(String::trim).filter(StringUtils::isNotBlank).map(License::new).collect(Collectors.toSet());
    }

    private void setFilePath(FileNode parentCompFileNode, @NonNull String pathAsString, CdxComponent cdxElement, FileElement fileElement) {
        FileNode parentFileFileNode = parentCompFileNode;
        if (pathAsString.contains("/")) {
            parentFileFileNode = this.setElementPath(pathAsString, parentFileFileNode);
            boolean found = false;
            for (FileNode fn : parentFileFileNode.getChildren()) {
                if (!cdxElement.getName().equals(fn.getName())) continue;
                found = true;
                fileElement.setFileNode(fn);
                break;
            }
            if (!found) {
                FileNode filefileNode = new FileNode(cdxElement.getName(), FileNode.FileNodeType.FILE, parentFileFileNode);
                fileElement.setFileNode(filefileNode);
            }
        }
    }

    private FileNode setElementPath(@NonNull String pathAsString, FileNode parentNode) {
        FileNode currentNode = parentNode;
        if (!pathAsString.contains("/")) {
            return currentNode;
        }
        for (String folderName : pathAsString.split("/")) {
            if (!StringUtils.isNotBlank((CharSequence)(folderName = folderName.trim()))) continue;
            FileNode finalCurrentNode = currentNode;
            String finalFolderName = folderName;
            currentNode = currentNode.getChildren().stream().filter(node -> node.getName().equals(finalFolderName)).findFirst().orElseGet(() -> new FileNode(finalFolderName, FileNode.FileNodeType.FOLDER, finalCurrentNode));
        }
        return currentNode;
    }

    private @NonNull FileNode getComponentSnippetNode(@NonNull String declaredByPath, FileNode rootNode) {
        FileNode currentNode = rootNode;
        Iterator pathSegments = Arrays.stream(declaredByPath.split("/")).filter(StringUtils::isNotBlank).iterator();
        while (pathSegments.hasNext()) {
            String pathSegment = (String)pathSegments.next();
            boolean isLastPart = !pathSegments.hasNext();
            FileNode finalCurrentNode = currentNode;
            currentNode = currentNode.stream().filter(child -> child.getName().equals(pathSegment)).findFirst().orElseGet(() -> new FileNode(pathSegment, isLastPart ? FileNode.FileNodeType.FILE : FileNode.FileNodeType.FOLDER, finalCurrentNode));
        }
        return currentNode;
    }

    private @NonNull Snippet createSnippet(@NonNull Component component, FileNode snippetFileNode) {
        return this.createSnippet(component.getName(), component.getName(), component.getVersion(), snippetFileNode, component);
    }

    private @NonNull Snippet createSnippet(String name, String project, String version, FileNode parent, Component component) {
        Snippet snippet = Snippet.builder().name(name).scaProject(project).fromFile(parent).component(component).build();
        Fields.field((String)version, arg_0 -> ((Snippet)snippet).setScaVersion(arg_0));
        return snippet;
    }
}

