/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner;

import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.analyzer.structure.FileElement;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.License;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.structure.Vulnerability;
import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.SnippetVertex;
import com.castsoftware.sca.scar.server.bom.handler.AnalyzerBomFetcher;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.util.java.Asyncs;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class BomScanner
extends Scanner {
    private static final ReentrantLock lock = new ReentrantLock();
    private final Bom currentBom;
    private final AnalyzerBomFetcher fetcher;
    private final Executor executor;
    private final String originalBomId;

    public BomScanner(Executor executor, AnalyzerBomFetcher fetcher, Bom currentBom, BomWizardConfiguration configuration) {
        super(null, configuration);
        this.fetcher = fetcher;
        this.currentBom = currentBom;
        this.executor = executor;
        this.originalBomId = this.getOriginalBomId();
    }

    public void scan() {
        this.configuration.notify((Event)BomCreatorEvents.scan((Scanner)this));
        this.info("Start %s scanner", new Object[]{this.getScannerName()});
        List<Object> sha256s = new ArrayList();
        if (!this.configuration.isOnlyPackage()) {
            sha256s = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getFiles().stream().map(FileElement::getSha256).distinct().toList();
        }
        List<ImmutablePair> snippets = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getSnippets().stream().map(s -> new ImmutablePair((Object)s.getScaProject(), (Object)s.getScaVersion())).toList();
        double eltSize = (double)(sha256s.size() + snippets.size()) + 1.0;
        Asyncs.waiting(sha256s.stream().map(s -> CompletableFuture.runAsync(() -> this.searchFile(s, eltSize), this.executor)));
        Asyncs.waiting(snippets.stream().map(s -> CompletableFuture.runAsync(() -> this.searchSnippet((String)s.getLeft(), (String)s.getRight(), eltSize), this.executor)));
        this.currentBom.getComponentsFromSource(this.getScannerSource()).forEach(c -> c.setPath(this.findMinimalPath(c.getFiles().stream().map(FileElement::getFileNode).map(FileNode::getPath).collect(Collectors.toSet()))));
        this.info("Found %d components from %s ", new Object[]{this.currentBom.getComponentsFromSource(this.getScannerSource()).size(), this.getScannerName()});
        this.info("End %s scanner", new Object[]{this.getScannerName()});
        this.configuration.notify((Event)Event.finish(this.getClass()));
    }

    private void searchFile(String sha256, double eltSize) {
        this.configuration.notify((Event)BomCreatorEvents.read((Scanner)this, (Double)(100.0 / eltSize * 0.95)));
        this.fetcher.getFileFromSha256(sha256, this.originalBomId).ifPresent(arg_0 -> this.manageExistingFile(arg_0));
    }

    private void searchSnippet(String name, String version, double eltSize) {
        this.configuration.notify((Event)BomCreatorEvents.read((Scanner)this, (Double)(100.0 / eltSize * 0.95)));
        this.fetcher.getSnippetFromNameAndVersion(name, version, this.originalBomId).ifPresent(arg_0 -> this.manageExistingSnippet(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageExistingFile(FileVertex vertex) {
        lock.lock();
        try {
            List<FileElement> elements = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getFiles().stream().filter(f -> f.getSha256().equals(vertex.getSha256())).toList();
            ComponentVertex cv = (ComponentVertex)this.fetcher.getComponentFromFile(vertex.getId()).orElseThrow(IllegalStateException::new);
            Component newComponent = this.currentBom.getCategory(DefaultCategory.valueOf((String)cv.getCategory().toUpperCase())).getOrCreateComponentWithVersion(cv.getName(), cv.getVersion() != null ? cv.getVersion() : "", this.getScannerSource(), false);
            if (newComponent.isEmpty()) {
                this.fillComponent(cv, newComponent);
            }
            elements.forEach(element -> element.move(newComponent));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageExistingSnippet(SnippetVertex vertex) {
        lock.lock();
        try {
            Snippet snippet = this.currentBom.getCategory(DefaultCategory.UNDEFINED).getComponent("Not Scanned", BomSource.LOCAL).getSnippets().stream().filter(s -> s.getName().equals(vertex.getName()) && vertex.getVersion().equals(StringUtils.defaultIfBlank((CharSequence)s.getScaVersion(), (CharSequence)""))).findAny().orElseThrow(IllegalStateException::new);
            ComponentVertex cv = (ComponentVertex)this.fetcher.getComponentFromSnippet(vertex.getId()).orElseThrow(IllegalStateException::new);
            Component newComponent = this.currentBom.getCategory(DefaultCategory.valueOf((String)cv.getCategory().toUpperCase())).getOrCreateComponentWithVersion(cv.getName(), cv.getVersion() != null ? cv.getVersion() : "", this.getScannerSource(), false);
            if (newComponent.isEmpty()) {
                this.fillComponent(cv, newComponent);
            }
            snippet.move(newComponent);
        }
        finally {
            lock.unlock();
        }
    }

    private void fillComponent(ComponentVertex cv, Component newComponent) {
        this.info("Found existing component %s", new Object[]{newComponent.getName()});
        BomComponentVertex bcv = this.fetcher.getComponentWithLV(cv.getId());
        newComponent.setSource(this.getScannerSource());
        newComponent.setScaId(bcv.getScaId());
        newComponent.setDescription(bcv.getDescription());
        newComponent.setRepositoryType(bcv.getRepoType());
        newComponent.setRepository(bcv.getRepository());
        newComponent.setLatestVersion(bcv.getLastVersion());
        newComponent.setVersion(bcv.getVersion());
        newComponent.setAllVersions(bcv.getAllVersions());
        newComponent.setLanguages(bcv.getLanguages());
        newComponent.setTopics(bcv.getTopics());
        newComponent.setReferences(bcv.getReferences());
        newComponent.setComments(bcv.getComments());
        newComponent.setUpToDate(bcv.getUpToDate());
        newComponent.setCopyrights(bcv.getCopyright());
        newComponent.setLicenses(bcv.getLicenses().stream().map(lv -> new License(lv.getSpdxId())).collect(Collectors.toSet()));
        newComponent.setVulnerabilities(bcv.getVulnerabilities().stream().map(vv -> Vulnerability.builder().vId(vv.getVId()).build()).collect(Collectors.toSet()));
        if (this.getScannerSource().equals((Object)BomSource.CATALOG)) {
            newComponent.setLinkedComponentId(bcv.getId());
        }
    }

    protected AnalyzerBomFetcher getFetcher() {
        return this.fetcher;
    }

    protected Bom getCurrentBom() {
        return this.currentBom;
    }

    protected abstract String getScannerName();

    protected abstract BomSource getScannerSource();

    protected abstract String getOriginalBomId();

    protected abstract void info(String var1, Object ... var2);
}

