/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.scanner;

import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.exception.BomScanException;
import com.castsoftware.sca.scar.server.analyzer.scanner.ArchiveScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArchiveScanner
extends Scanner {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(ArchiveScanner.class);
    private final Bom scanning;

    public ArchiveScanner(Bom scanning, BomWizardConfiguration configuration) {
        super(null, configuration);
        this.scanning = scanning;
    }

    public void scan() {
        this.configuration.notify((Event)BomCreatorEvents.scan((Scanner)this));
        this.info("Start Archive scanner", new Object[0]);
        try {
            Path archiveFolder = Files.createTempDirectory("ark", new FileAttribute[0]);
            String sourcePath = this.getScanning().getSourcePath();
            Path source = Paths.get(sourcePath, new String[0]);
            if (sourcePath.toLowerCase().endsWith(".zip") || sourcePath.toLowerCase().endsWith(".jar")) {
                ArchiveScanner.unzipArchive((Path)source, (Path)archiveFolder);
            } else if (sourcePath.toLowerCase().endsWith(".tar.gz") || sourcePath.toLowerCase().endsWith(".tgz")) {
                ArchiveScanner.untarArchive((Path)source, (Path)archiveFolder, (SubCompress)SubCompress.GZ);
            } else if (sourcePath.toLowerCase().endsWith(".tar.xz") || sourcePath.toLowerCase().endsWith(".txz")) {
                ArchiveScanner.untarArchive((Path)source, (Path)archiveFolder, (SubCompress)SubCompress.XZ);
            } else if (sourcePath.toLowerCase().endsWith(".tar")) {
                ArchiveScanner.untarArchive((Path)source, (Path)archiveFolder, (SubCompress)SubCompress.NONE);
            } else {
                throw new IOException("Unknown archive format");
            }
            this.getScanning().setLocalSourcePath(archiveFolder.toFile().getAbsolutePath());
            this.info("End Archive scanner", new Object[0]);
            this.configuration.notify((Event)Event.finish(this.getClass()));
        }
        catch (IOException e) {
            throw new BomScanException("archive_scanner_error", "Unexpected error whilst unpacking archive", (Throwable)e);
        }
    }

    private Bom getScanning() {
        return this.scanning;
    }

    private void info(String format, Object ... objects) {
        this.log(LOGGER, ArchiveScanner.class, this.getScanning(), format, objects);
    }

    private static void unzipArchive(Path source, Path target) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(source.toFile()));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = zipEntry.isDirectory();
                if (!isDirectory && zipEntry.getName().endsWith(File.separator)) {
                    isDirectory = true;
                }
                Path newPath = ArchiveScanner.zipSlipProtect((String)zipEntry.getName(), (Path)target);
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private static void untarArchive(Path source, Path target, SubCompress sub) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)(sub == SubCompress.GZ ? new GzipCompressorInputStream((InputStream)bis) : (sub == SubCompress.XZ ? new XZCompressorInputStream((InputStream)bis) : bis)));){
            TarArchiveEntry entry;
            while ((entry = tis.getNextEntry()) != null) {
                Path newPath = ArchiveScanner.zipSlipProtect((String)entry.getName(), (Path)target);
                if (entry.isDirectory()) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                    continue;
                }
                Path parent = newPath.getParent();
                if (parent != null && Files.notExists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.copy((InputStream)tis, newPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static Path zipSlipProtect(String entryName, Path targetDir) throws IOException {
        Path normalizedPath = targetDir.resolve(entryName).normalize();
        if (!normalizedPath.startsWith(targetDir)) {
            throw new IOException("Bad archive entry: " + entryName);
        }
        return normalizedPath;
    }
}

