/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer;

import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.ArchiveScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.CatalogScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.CycloneDxScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.FileScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.FolderScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.GitScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.HlCsvScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.NoScaScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.PreviousScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.ScaScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.packageScanner.PackageScanner;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Category;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.bom.handler.AnalyzerBomFetcher;
import com.castsoftware.sca.scar.server.bom.handler.ScannerPreferenceFetcher;
import com.castsoftware.sca.scar.server.sam.requester.DataApiRequester;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class BomCreator
implements AutoCloseable {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(BomCreator.class);
    public static final String NOT_SCANNED_COMPONENT = "Not Scanned";
    public static final String NOT_FOUND_COMPONENT = "Not Found";
    public static final String SCA_FOUND_COMPONENT = "Found in SCA";
    private final ExecutorService executor = Executors.newFixedThreadPool(10);
    private final DataApiRequester dataAPI;
    private final AnalyzerBomFetcher analyzerBomFetcher;
    private final ScannerPreferenceFetcher scannerPreferenceFetcher;

    public BomCreator(DataApiRequester dataAPI, AnalyzerBomFetcher analyzerBomFetcher, ScannerPreferenceFetcher scannerPreferenceFetcher) {
        this.dataAPI = dataAPI;
        this.analyzerBomFetcher = analyzerBomFetcher;
        this.scannerPreferenceFetcher = scannerPreferenceFetcher;
    }

    public Bom create(BomWizardConfiguration configuration) {
        Optional oConfig = Opt.ofNullable((Object)configuration);
        oConfig.orElseThrow(IllegalArgumentException::new);
        Bom currentBom = Bom.builder().product(configuration.getProduct()).project(configuration.getProject()).version(configuration.getVersion()).licensePolicy(configuration.getLicensePolicy()).sourcePath(configuration.getSourcePath()).creationTimestamp(Instant.now().toEpochMilli()).build();
        configuration.notify((Event)BomCreatorEvents.configureCreator());
        ArrayList scanners = new ArrayList();
        oConfig.filter(BomCreator.sourceIn((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.FILE})).map(c -> new FolderScanner(currentBom, configuration)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(BomCreator.sourceIn((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.GIT})).map(c -> new GitScanner(currentBom, configuration)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(BomCreator.sourceIn((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.ARCHIVE})).map(c -> new ArchiveScanner(currentBom, configuration)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(BomCreator.sourceIn((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.HLCSV})).map(c -> new HlCsvScanner(currentBom, configuration)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(BomCreator.sourceIn((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.CYCLONE_DX})).map(c -> new CycloneDxScanner(currentBom, configuration, this.analyzerBomFetcher, this.dataAPI)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(BomCreator.sourceNot((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.HLCSV, BomWizardConfiguration.SourceType.CYCLONE_DX})).map(c -> new FileScanner((Executor)this.executor, currentBom, configuration)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(BomWizardConfiguration::isUsePackage).filter(BomCreator.sourceNot((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.CYCLONE_DX})).map(c -> new PackageScanner(currentBom, configuration, this.scannerPreferenceFetcher)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(BomWizardConfiguration::isUsePrevious).filter(BomCreator.sourceNot((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.CYCLONE_DX})).map(c -> new PreviousScanner((Executor)this.executor, this.analyzerBomFetcher, currentBom, configuration)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(BomWizardConfiguration::isUseCatalog).filter(BomCreator.sourceNot((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.CYCLONE_DX})).map(c -> new CatalogScanner((Executor)this.executor, this.analyzerBomFetcher, currentBom, configuration)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(BomWizardConfiguration::isUseSca).filter(BomCreator.sourceNot((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.CYCLONE_DX})).map(c -> new ScaScanner((Executor)this.executor, this.dataAPI, currentBom, configuration, this.analyzerBomFetcher)).map(Functions.peek(scanners::add)).map(BomCreatorEvents::addScan).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).notify(arg_0));
        oConfig.filter(c -> !c.isUseSca()).filter(BomCreator.sourceNot((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.CYCLONE_DX})).ifPresent(c -> {
            boolean hasLocalScanner = scanners.stream().anyMatch(s -> s instanceof PreviousScanner || s instanceof CatalogScanner);
            scanners.add(new NoScaScanner(currentBom, hasLocalScanner, configuration));
        });
        oConfig.filter(BomCreator.sourceNot((BomWizardConfiguration.SourceType[])new BomWizardConfiguration.SourceType[]{BomWizardConfiguration.SourceType.CYCLONE_DX})).ifPresent(c -> {
            DefaultCategory.stream().map(Category::new).forEach(arg_0 -> ((Bom)currentBom).addCategory(arg_0));
            Component notScanned = new Component();
            notScanned.setName("Not Scanned");
            notScanned.setSource(BomSource.LOCAL);
            currentBom.getCategory(DefaultCategory.UNDEFINED).addComponent(notScanned);
        });
        scanners.forEach(Scanner::scan);
        this.clean(currentBom);
        configuration.notify((Event)Event.finish(this.getClass()));
        return currentBom;
    }

    private static @NonNull Predicate<BomWizardConfiguration> sourceIn(BomWizardConfiguration.SourceType ... sourceTypes) {
        return o -> Arrays.stream(sourceTypes).anyMatch(st -> st.equals((Object)o.getSourceType()));
    }

    private static @NonNull Predicate<BomWizardConfiguration> sourceNot(BomWizardConfiguration.SourceType ... sourceTypes) {
        return BomCreator.sourceIn((BomWizardConfiguration.SourceType[])sourceTypes).negate();
    }

    public void clean(@NonNull Bom currentBom) {
        currentBom.getCategories().forEach(Category::clean);
    }

    @Override
    public void close() throws Exception {
        this.executor.shutdown();
    }
}

