/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.SCArApplication;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class SCArApplicationLauncher {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SCArApplicationLauncher.class);

    public static void main(String[] args) {
        Arrays.stream(args).filter(arg -> arg.contains("server.data=")).findFirst().map(s -> s.split("=")[1]).ifPresent(SCArApplication::setHomeFolder);
        Path defaultLocation = (Path)SCArApplication.defaultResourceLocation(Path::toAbsolutePath);
        Stream<String> builtArgs = Stream.of(String.format("--scar.config.location=%s", defaultLocation.toString()), "--spring.config.name=scar", String.format(Locale.ROOT, "--spring.config.location=classpath:application-default.yml,optional:%s", defaultLocation.resolve("scar.yml")));
        String[] completeArgs = (String[])Stream.concat(Arrays.stream(args), builtArgs).toArray(String[]::new);
        Optional.of(LOGGER).filter(Logger::isDebugEnabled).ifPresent(l -> l.debug(String.format("SCAr is launched with these arguments: %s", String.join((CharSequence)" | ", completeArgs))));
        ConfigurableApplicationContext applicationContext = new SpringApplicationBuilder(new Class[]{SCArApplicationLauncher.class}).headless(false).run(completeArgs);
        Optional.ofNullable(applicationContext).map(ap -> (SCArApplication)ap.getBean(SCArApplication.class)).ifPresent(SCArApplication::start);
    }
}

