# highlight-scan-GitLab-CI/CD
This repo contains a sample gitlab-ci.yml file for running CAST Highlight scans on repositories. CAST Highlight offers automated source code analysis of hundreds 
of applications in a week for Cloud Maturity, Open Source risks, Resiliency, Agility and Green Software. Objective software insights combined with qualitative  
surveys for business context.


# Prerequisites:
- A valid CAST Highlight user account, company and application IDs to upload the results to CAST Highlight SaaS Portal automatically.
- Define following variables in the GitLab project settings (Settings> CI/CD> Variables):
	1- $HLTOKEN: This is your CAST Highlight generated user token for the Highlight API/CLI token.
	2- $HLCOMPANYID: This is your CAST Highlight Company ID
	3- $HLAPPLICATIONID: This is the application ID


For more information on how to enable CAST Highlight API/CLI tokens, see this page: https://doc.casthighlight.com/feature-focus-api-cli-user-token-management/

For more information on how to use the CAST Highlight CLI Docker image, see this page: https://doc.casthighlight.com/product-tutorials-third-party-tools/cast-highlights-docker-image-code-scans/

For more information about CAST Highlight and Software Intelligence: https://www.castsoftware.com/products/highlight/

